<?php
/* ---------------------------------------------------------------------------------------
   $Id: commerce_seo_url.php,v 1.1 2010/09/08 10:50:55 akausch Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   ---------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(cod.php,v 1.28 2003/02/14); www.oscommerce.com 
   (c) 2003	 nextcommerce (invoice.php,v 1.6 2003/08/24); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------
    
   Basiert auf: bluegate - Author: Ing. Michael Fürst
   
   #######################################################################################
   
   Modifiziert und erweitert von commerce:SEO v2
   
*/
defined( '_VALID_XTC' ) or die( 'Direct Access to this location is not allowed.' );

define('MODULE_COMMERCE_SEO_INDEX_TEXT_DESCRIPTION', 'Der Indexierungsdienst erstellt die SUMA-freundlichen Direct URLs f&uuml;rr Ihren Shop.');
define('MODULE_COMMERCE_SEO_INDEX_TEXT_TITLE', 'commerce:SEO URL v2.1');
define('MODULE_COMMERCE_SEO_INDEX_STATUS_DESC','Modulstatus');
define('MODULE_COMMERCE_SEO_URL_LENGHT_TITLE', 'Kurze URLs?');
define('MODULE_COMMERCE_SEO_URL_LENGHT_DESC','Sollen kurze URL\'s genutzt werden?');
define('MODULE_COMMERCE_SEO_INDEX_STATUS_TITLE','Status');
define('MODULE_COMMERCE_SEO_INDEX_LANGUAGEURL_TITLE','Sprachabh&auml;ngige URLs<br />../de/.. | ../en/..');
define('MODULE_COMMERCE_SEO_INDEX_LANGUAGEURL_DESC','Die suchmaschinenfreundlichen URLs werden sprachabh&auml;ngig kodiert');
define('MODULE_COMMERCE_SEO_INDEX_AVOIDDUPLICATECONTENT_TITLE','Doppelten Content vermeiden');
define('MODULE_COMMERCE_SEO_INDEX_AVOIDDUPLICATECONTENT_DESC','Aktivieren Sie diese Option um Doppelten Content zu vermeiden (Code 301 Redirect).');
define('MODULE_COMMERCE_SEO_INDEX_CREATENEWINDEX_TITLE','Indexierung durchführen');
define('MODULE_COMMERCE_SEO_INDEX_CREATENEWINDEX_DESC','Aktivieren Sie diese Option um beim Speichern alle Seiten neu zu indexieren.');
define('INDEX_START','<strong>Indexierung starten</strong>');
define('INDEX_START_DESCRIPTION','Klicken Sie auf "OK" um die Einstellungen zu speichern. Ist die Option "Indexierung durchführen" auf "True" gesetzt, kann dieser Vorgang einige Zeit in Anspruch nehmen. Brechen Sie diese Operation keinesfalls ab!');

class commerce_seo_url {
	var $code, $title, $description, $enabled, $seourl;
	
	function commerce_seo_url() {
		global $order;

		$this->code = 'commerce_seo_url';
		$this->title = MODULE_COMMERCE_SEO_INDEX_TEXT_TITLE;
		$this->description = MODULE_COMMERCE_SEO_INDEX_TEXT_DESCRIPTION;
		$this->sort_order = MODULE_COMMERCE_SEO_INDEX_SORT_ORDER;
		$this->enabled = ((MODULE_COMMERCE_SEO_INDEX_STATUS == 'True') ? true : false);
		$this->lenght = ((MODULE_COMMERCE_SEO_URL_LENGHT == 'False') ? true : false);
	}

    function process($file) {
		require_once(DIR_FS_INC . 'commerce_seo.inc.php');
  		!$commerceSeo ? $commerceSeo = new CommerceSeo() : false;
		
		if($_REQUEST['startindex']=='true') {
			$commerceSeo->createSeoDBTable();
		}
    }

    function display() {
		$pulldown_option[0]['text']='Ja';
		$pulldown_option[0]['id']='true';
		$pulldown_option[1]['text']='Nein';
		$pulldown_option[1]['id']='false';
		
		return array('text' => 	'<br /><strong>Indexierung durchf&uuml;hren?</strong><br />
								Sollen alle Seiten beim Klick auf "OK" indiziert werden?<br />'.
                            	xtc_draw_pull_down_menu('startindex',$pulldown_option,'Ja').'<br /><br />'.
 								xtc_button(BUTTON_REVIEW_APPROVE) . '&nbsp;' .
								xtc_button_link(BUTTON_CANCEL, xtc_href_link(FILENAME_MODULE_SYSTEM, 'set=' . $_GET['set'] . '&module=commerce_seo_url')));
    }

    function check() {
    	if (!isset($this->_check)) {
	      $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_COMMERCE_SEO_INDEX_STATUS'");
	      $this->_check = xtc_db_num_rows($check_query);
	    }
	    return $this->_check;
    }

    function install() {
		xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_COMMERCE_SEO_INDEX_STATUS', 'True',  '111', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
		xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_COMMERCE_SEO_INDEX_LANGUAGEURL', 'False',  '111', '2', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
		xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_COMMERCE_SEO_INDEX_AVOIDDUPLICATECONTENT', 'True',  '111', '3', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
		xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_COMMERCE_SEO_URL_LENGHT', 'False',  '111', '4', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
		xtc_db_query("UPDATE " . TABLE_CONFIGURATION . " SET configuration_value = 'true' WHERE configuration_key = 'SEARCH_ENGINE_FRIENDLY_URLS'");

		// Tabellenstruktur commerce_seo_url anlegen, wenn noch nicht vorhanden
		$createTableQuery =	"CREATE TABLE IF NOT EXISTS `commerce_seo_url` (
							`url_md5` varchar(32) NOT NULL default '',
							`url_text` varchar(255) NOT NULL default '',
							`products_id` int(11) default NULL,
							`categories_id` int(11) default NULL,
							`blog_id` int(11) default NULL,
							`blog_cat` int(11) default NULL,
							`content_group` int(11) default NULL,
							`language_id` int(11) NOT NULL default '0',
							PRIMARY KEY  (`url_md5`),
							KEY `url_text` (`url_text`,`products_id`));";
		xtc_db_query($createTableQuery);
	}

    function remove() {
    	xtc_db_query("DELETE FROM " . TABLE_CONFIGURATION . " WHERE configuration_key IN ('" . implode("', '", $this->keys()) . "')");
    	xtc_db_query("DROP TABLE `commerce_seo_url`");
		xtc_db_query("UPDATE " . TABLE_CONFIGURATION . " SET configuration_value = 'false' WHERE configuration_key = 'SEARCH_ENGINE_FRIENDLY_URLS'");
    }

    function keys() {
      	return array('MODULE_COMMERCE_SEO_INDEX_STATUS','MODULE_COMMERCE_SEO_INDEX_LANGUAGEURL','MODULE_COMMERCE_SEO_URL_LENGHT','MODULE_COMMERCE_SEO_INDEX_AVOIDDUPLICATECONTENT');
    }

  }
?>